@extends($layout_path)

@section('title', $app_setting['name'] . ' | ' . __('Contact Messages'))

@section('header-title')
    <h3 class="title">{{ __('Contact Messages') }}</h3>
@endsection

@push('styles')
    <style>
        .message_icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            background: #f6f7f9;
            border: 1px solid #efeded;
            margin-bottom: 12px;
        }

        .message_title h4 {
            font-family: Inter, sans-serif;
            font-weight: 600;
            font-size: 20px;
        }

        .delete_message {
            position: absolute;
            top: 10px;
            right: 10px;
            cursor: pointer;
        }

        .message_description {
            margin-top: 15px;
            height: 170px;
        }

        .gridView {
            display: block;
        }

        .listView {
            display: none;
        }
    </style>
@endpush

@section('content')
    <div class="app-main-outer">
        <div class="app-main-inner">

            <div class="page-title-actions px-3 d-flex align-items-center justify-content-between flex-wrap gap-3">
                <nav aria-label="breadcrumb" class="modern-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fa-solid fa-house"></i>
                                {{ __('Dashboard') }}
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fa-solid fa-layer-group"></i>
                            {{ __('Contact Messages') }}
                        </li>
                    </ol>
                </nav>
                <a href="javascript:void(0)" onclick="window.location.reload();" class="refresh-btn">
                    <i class="fa-solid fa-retweet"></i>
                    <span>{{ __('Refresh Page') }}</span>
                </a>
            </div>


            <div class="row">
                <div class="col-lg-12 my-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-8">
                                    <h3 class="m-0 p-0">
                                        {{ __('Contact Messages') }}</h3>
                                </div>
                                <div class="col-4">
                                    <div class="btn-group float-end" role="group" aria-label="Basic example">
                                        <button type="button" class="btn btn-outline-secondary" onclick="gridView()">
                                            <i class="bi bi-grid"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary active"
                                            onclick="listView()">
                                            <i class="bi bi-list"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="row">
                        @forelse ($allcontacts as $contact)
                            <div class="col-lg-4 my-3 gridView">
                                <div class="card position-relative">
                                    <div class="card-body">
                                        @if (!$contact->state)
                                            <div class="mb-3">
                                                <span class="badge bg-warning">
                                                    {{ __('unread') }}
                                                </span>
                                            </div>
                                        @else
                                            <div class="mb-3">
                                                <span class="badge bg-success">
                                                    {{ __('read') }} <i class="bi bi-check-all"></i>
                                                </span>
                                            </div>
                                        @endif
                                        <div class="message_icon">
                                            <img src="{{ asset('assets/images/menu/message.svg') }}" alt="icon">
                                        </div>
                                        <div class="message_title">
                                            <h4>{{ $contact->name }}</h4>
                                        </div>
                                        <div class="message_description mb-3">
                                            <p class="mb-2">{{ __('Subject') }} : <span
                                                    class="fw-bold">{{ $contact->subject }}</span>
                                            </p>
                                            <p class="text-muted">
                                                {{ \Illuminate\Support\Str::limit($contact->message, 120, ' ...') }}
                                            </p>
                                        </div>
                                        <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal"
                                            data-bs-target="#contactDetailsShowModal{{ $contact->id }}"
                                            onclick="readMessage({{ $contact->id }})">{{ __('Read More') }}</button>
                                    </div>
                                    <div class="delete_message">
                                        <a href="{{ route('contact.destroy', $contact->id) }}" data-bs-toggle="tooltip"
                                            data-bs-placement="top" data-bs-custom-class="custom-tooltip"
                                            data-bs-title="{{ __('Delete Message') }}">
                                            <img src="{{ asset('assets/images/icon/trash.svg') }}" alt="icon">
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12 my-3 listView">
                                <div class="card shadow-sm border-0 rounded-3 position-relative message-card">
                                    <div class="card-body d-flex align-items-center justify-content-between flex-wrap">
                                        <div class="d-flex align-items-center gap-3">
                                            {{-- Read / Unread Badge --}}
                                            @if (!$contact->state)
                                                <span class="badge bg-warning px-3 py-2 rounded-pill shadow-sm">
                                                    <i class="bi bi-envelope"></i> {{ __('Unread') }}
                                                </span>
                                            @else
                                                <span class="badge bg-success px-3 py-2 rounded-pill shadow-sm">
                                                    <i class="bi bi-check-all"></i> {{ __('Read') }}
                                                </span>
                                            @endif

                                            {{-- Icon --}}
                                            <div class="message_icon bg-light rounded-circle d-flex align-items-center justify-content-center shadow-sm"
                                                style="width: 50px; height: 50px;">
                                                <img src="{{ asset('assets/images/menu/message.svg') }}" alt="icon"
                                                    class="img-fluid" style="width: 24px;">
                                            </div>

                                            {{-- Title & Small Details --}}
                                            <div class="message_title">
                                                <h5 class="fw-bold mb-1">{{ $contact->name }}</h5>
                                                <small class="text-muted">Subject: <span
                                                        class="fw-semibold">{{ $contact->subject }}</span></small>
                                            </div>
                                        </div>

                                        {{-- Actions --}}
                                        <div class="d-flex align-items-center gap-2 mt-3 mt-lg-0">
                                            <button type="button" class="btn btn-sm btn-outline-primary rounded-pill px-3"
                                                data-bs-toggle="modal"
                                                data-bs-target="#contactDetailsShowModal{{ $contact->id }}"
                                                onclick="readMessage({{ $contact->id }})">
                                                <i class="bi bi-eye"></i> {{ __('Read More') }}
                                            </button>

                                            <a href="{{ route('contact.destroy', $contact->id) }}"
                                                class="btn btn-sm btn-outline-danger rounded-pill px-3"
                                                data-bs-toggle="tooltip" data-bs-placement="top"
                                                data-bs-custom-class="custom-tooltip"
                                                data-bs-title="{{ __('Delete Message') }}">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            {{-- modal start --}}

                            <div class="modal fade" id="contactDetailsShowModal{{ $contact->id }}" tabindex="-1"
                                aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content border-4 border-primary">
                                        <div class="modal-header">
                                            <h1 class="modal-title fs-5 fw-bolder" id="exampleModalLabel">
                                                {{ __('Contact Message') }}
                                            </h1>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close" onclick="window.location.reload()"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p>{{ __('Name') }} : <span class="fw-bold">{{ $contact->name }}</span>
                                            </p>
                                            <p>{{ __('Email') }} : <span class="fw-bold">{{ $contact->email }}</span>
                                            </p>
                                            <p>{{ __('Subject') }} : <span class="fw-bold">{{ $contact->subject }}</span>
                                            </p>
                                            <p class="fw-bold">{{ __('Message') }} : </p>
                                            <p class="text-muted">
                                                {{ $contact->message }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- modal end --}}

                        @empty
                            <div class="row">
                                <div class="col-12">
                                    <div class="alert alert-primary text-center">
                                        <h5 class="alert-heading m-0 fw-bold text-danger">
                                            {{ __('No information available') }}.</h5>
                                    </div>
                                </div>
                            </div>
                        @endforelse

                    </div>
                </div>
                {{ $allcontacts->links() }}
            </div>
            <!-- ****End-Body-Section***** -->
        </div>
    </div>
@endsection


@push('styles')
    <style>
        .message-card {
            transition: all 0.3s ease-in-out;
        }

        .message-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
        }
    </style>
@endpush

@push('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            listView(); // show list view by default
        });

        function readMessage(id) {
            $.ajax({
                url: `/admin/contact/show/${id}`,
                type: "get",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(data) {
                    console.log(data);
                }
            });
        }

        function listView() {
            let gridItems = document.querySelectorAll('.gridView');
            let listItems = document.querySelectorAll('.listView');

            gridItems.forEach(item => {
                item.style.display = 'none';
            });

            listItems.forEach(item => {
                item.style.display = 'block';
            });

            toggleActiveClass('list');
        }

        function gridView() {
            let gridItems = document.querySelectorAll('.gridView');
            let listItems = document.querySelectorAll('.listView');

            gridItems.forEach(item => {
                item.style.display = 'block';
            });

            listItems.forEach(item => {
                item.style.display = 'none';
            });
            toggleActiveClass('grid');
        }


        function toggleActiveClass(view) {
            // Get both buttons
            let gridButton = document.querySelector('button[onclick="gridView()"]');
            let listButton = document.querySelector('button[onclick="listView()"]');

            // Remove active class from both buttons
            gridButton.classList.remove('active');
            listButton.classList.remove('active');

            // Add active class to the corresponding button
            if (view == 'grid') {
                gridButton.classList.add('active');
            } else {
                listButton.classList.add('active');
            }
        }
    </script>
@endpush
