@extends($layout_path)

@section('title', $app_setting['name'] . ' | ' . __('Page Edit'))

@section('header-title')
    <h3 class="title">{{ __('Update - ') . $page->title . ' ' . __('Page') }}</h3>
@endsection

@push('styles')
    <link rel="stylesheet" href="https://cdn.ckeditor.com/ckeditor5/43.2.0/ckeditor5.css" />
    <style>
        .ck-editor__editable {
            min-height: 140px;
            caret-color: black;
        }
    </style>
@endpush

@section('content')
    <!-- ****Body-Section***** -->
    <div class="app-main-outer">
        <div class="app-main-inner">
            <div class="page-title-actions px-3 d-flex align-items-center justify-content-between flex-wrap gap-3">
                <nav aria-label="breadcrumb" class="modern-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fa-solid fa-house"></i>
                                {{ __('Dashboard') }}
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fa-solid fa-layer-group"></i>
                            {{ $page->title . ' ' . __('Page') }}
                        </li>
                    </ol>
                </nav>
                <a href="javascript:void(0)" onclick="window.location.reload();" class="refresh-btn">
                    <i class="fa-solid fa-retweet"></i>
                    <span>{{ __('Refresh Page') }}</span>
                </a>
            </div>

            <div class="row" id="deleteTableItem">
                <div class="col-md-12 my-3">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="m-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <div class="main-card card d-flex h-100 flex-column">
                        <div class="card-body">
                            <form action="{{ route('page.update', $slug) }}" method="POST" enctype="multipart/form-data">
                                @csrf @method('PUT')
                                <div class="row">
                                    <div class="mb-3">
                                        <textarea name="content" class="texteditor form-control description-item">{{ $page?->content }}</textarea>
                                    </div>
                                    <div class="col-12 text-end">
                                        <button type="submit" class="btn btn-primary btn-lg px-5">{{ __('Update') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://cdn.ckeditor.com/ckeditor5/43.2.0/ckeditor5.umd.js"></script>

    <script>
        const {
            ClassicEditor,
            Essentials,
            Bold,
            Italic,
            Font,
            Paragraph,
            Alignment,
            BlockQuote,
            Heading,
            Indent,
            Link,
            List,
            Table,
            MediaEmbed,
            Image,
            ImageCaption,
            ImageResize,
            ImageToolbar,
            ImageStyle,
            ImageUpload,
            SourceEditing,
            CodeBlock,
            Underline,
            Strikethrough,
            Highlight,
            HorizontalLine
        } = CKEDITOR;

        ClassicEditor
            .create(document.querySelector('.texteditor'), {
                plugins: [
                    Essentials, Bold, Italic, Font, Paragraph, Alignment, BlockQuote, Heading, Indent, Link, List,
                    Table, MediaEmbed, Image, ImageCaption, ImageResize, ImageToolbar, ImageStyle, ImageUpload,
                    SourceEditing, CodeBlock, Underline, Strikethrough, Highlight, HorizontalLine
                ],
                toolbar: [
                    'undo', 'redo', '|', 'heading', '|', 'bold', 'italic', 'underline', 'strikethrough',
                    'highlight', '|',
                    'alignment', '|', 'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', '|',
                    'link', 'blockquote', 'codeBlock', 'horizontalLine', '|', 'bulletedList', 'numberedList', '|',
                    'insertTable', 'mediaEmbed', 'imageUpload', '|', 'indent', 'outdent', '|', 'sourceEditing'
                ],
                image: {
                    toolbar: [
                        'imageTextAlternative', 'imageStyle:inline', 'imageStyle:block', 'imageStyle:side',
                        'linkImage'
                    ]
                },
                table: {
                    contentToolbar: [
                        'tableColumn', 'tableRow', 'mergeTableCells'
                    ]
                },
                mediaEmbed: {
                    previewsInData: true
                }
            })
            .then(editor => {
                console.log('Editor initialized successfully!');
            })
            .catch(error => {
                console.error(error);
            });
    </script>
@endpush
